# 🏠 Instrucciones de Instalación - Tema Corredora Properties

## 📋 Requisitos Previos

- **WordPress 5.0+** instalado
- **PHP 7.4+** 
- **MySQL 5.6+** o **MariaDB 10.1+**
- **Servidor web** (Apache/Nginx)

## 🚀 Pasos de Instalación

### 1. Configurar la Base de Datos

1. Crea una nueva base de datos llamada `corredora_db`
2. Crea un usuario de base de datos con permisos completos
3. Actualiza las credenciales en `wp-config.php` si es necesario

### 2. Activar el Tema

1. Ve al panel de administración de WordPress
2. Navega a **Apariencia > Temas**
3. Busca "Corredora Properties" en la lista de temas
4. Haz clic en **Activar**

### 3. Configuración Inicial

#### 3.1 Configurar Menús
1. Ve a **Apariencia > Menús**
2. Crea un nuevo menú llamado "Menú Principal"
3. Agrega las siguientes páginas:
   - Inicio
   - Propiedades
   - Sobre Nosotros
   - Contacto
4. Asigna el menú a la ubicación "Menú Principal"

#### 3.2 Configurar Logo
1. Ve a **Apariencia > Personalizar**
2. Busca la sección "Identidad del sitio"
3. Sube tu logo (recomendado: 200x60 píxeles)
4. Guarda los cambios

#### 3.3 Crear Páginas Importantes
1. **Página de Inicio**: Ya configurada automáticamente
2. **Página de Propiedades**: Crea una página llamada "Propiedades"
3. **Página de Contacto**: Crea una página llamada "Contacto"
4. **Página Sobre Nosotros**: Crea una página llamada "Sobre Nosotros"

### 4. Configurar Propiedades

#### 4.1 Crear Tipos de Propiedad
1. Ve a **Propiedades > Tipos**
2. Agrega los tipos que necesites:
   - Casa
   - Apartamento
   - Oficina
   - Local Comercial
   - Terreno

#### 4.2 Crear Ubicaciones
1. Ve a **Propiedades > Ubicaciones**
2. Agrega las ubicaciones de tu mercado:
   - Centro
   - Zona Norte
   - Zona Sur
   - Zona Este
   - Zona Oeste

#### 4.3 Agregar Propiedades
1. Ve a **Propiedades > Agregar Nueva**
2. Completa la información básica:
   - Título de la propiedad
   - Descripción detallada
   - Imagen destacada
3. Configura los detalles:
   - Precio
   - Metros cuadrados
   - Habitaciones
   - Baños
   - Garaje
   - Dirección
   - Estado (Disponible/Vendido/Reservado)
4. Asigna el tipo y ubicación
5. Publica la propiedad

### 5. Personalización Adicional

#### 5.1 Widgets del Footer
1. Ve a **Apariencia > Widgets**
2. Configura los widgets en "Footer Widgets"
3. Agrega información de contacto, enlaces útiles, etc.

#### 5.2 Configurar Información de Contacto
1. Edita el archivo `header.php` y `footer.php`
2. Actualiza los números de teléfono y emails
3. Modifica las direcciones según tu ubicación

#### 5.3 Personalizar Colores (Opcional)
1. Edita el archivo `style.css`
2. Modifica las variables CSS en la sección `:root`
3. Cambia los colores según tu marca

## 🎨 Características del Tema

### ✅ Funcionalidades Incluidas
- **Diseño Responsivo**: Se adapta a todos los dispositivos
- **Búsqueda Avanzada**: Filtros por precio, ubicación, tipo
- **Sistema de Favoritos**: Los usuarios pueden marcar propiedades
- **Integración WhatsApp**: Botón flotante para contacto directo
- **SEO Optimizado**: Estructura semántica y meta tags
- **Velocidad Optimizada**: Código limpio y eficiente

### 🎯 Páginas Principales
1. **Página de Inicio**: Hero section, propiedades destacadas, servicios
2. **Página de Propiedades**: Listado con filtros avanzados
3. **Página de Contacto**: Formulario y información de contacto
4. **Páginas de Propiedades Individuales**: Detalles completos

### 📱 Elementos Móviles
- Menú hamburguesa responsivo
- Botón de WhatsApp flotante
- Botón de scroll to top
- Formularios optimizados para móvil

## 🔧 Mantenimiento

### Actualizaciones
- Mantén WordPress actualizado
- Actualiza plugins regularmente
- Haz respaldos de la base de datos

### Optimización
- Optimiza las imágenes antes de subirlas
- Usa un plugin de caché
- Monitorea la velocidad del sitio

## 🆘 Soporte

Si encuentras algún problema:

1. **Revisa los logs de error** en el panel de WordPress
2. **Verifica la configuración** de la base de datos
3. **Desactiva plugins** temporalmente para identificar conflictos
4. **Contacta al desarrollador** si el problema persiste

## 📞 Información de Contacto

- **Email**: info@corredora.com
- **Teléfono**: +1 (234) 567-890
- **WhatsApp**: +1 (234) 567-890

---

¡Tu sitio web de corredora de propiedades está listo para funcionar! 🎉


